<?php

namespace App\Modules\GroupPassenger\Application\DownloadMedia;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DownloadMediaGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private GroupPassengerMediaDownloader $downloader
    ) {
    }

    public function __invoke(DownloadMediaGroupPassengerQuery $query): DownloadMediaGroupPassengerResponse
    {
        $response = $this->downloader->__invoke(new IdGroupPassenger($query->id()));
        return new DownloadMediaGroupPassengerResponse($response);
    }
}
