<?php

namespace App\Modules\Group\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\GroupReferredFrom\Domain\IdGroupReferredFrom;
use App\Modules\GroupRelationship\Domain\IdGroupRelationship;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\StatusGroup\Domain\IdStatusGroup;
use App\Modules\User\Domain\IdUser;

class Group extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdGroup::class, 'Id_Group', 'primary'),
            new AggregateAttribute('date', GroupDate::class, 'Group_Date'),
            new AggregateAttribute('dateUpdate', GroupDateUpdate::class, 'Group_DateUpdate'),
            new AggregateAttribute('dateStart', GroupDateStart::class, 'Group_DateStart'),
            new AggregateAttribute('dateEnd', GroupDateEnd::class, 'Group_DateEnd'),
            new AggregateAttribute('hour', GroupHour::class, 'Group_Hour'),
            new AggregateAttribute('name', GroupName::class, 'Group_Name'),
            new AggregateAttribute('token', GroupToken::class, 'Group_Token'),
            new AggregateAttribute('origin', GroupOrigin::class, 'Group_Origin'),
            new AggregateAttribute('Destination', GroupDestination::class, 'Group_Destination'),
            new AggregateAttribute('type', GroupType::class, 'Group_Type'),
            new AggregateAttribute('order', GroupOrder::class, 'Group_Order'),
            new AggregateAttribute('tourDuration', GroupTourDuration::class, 'Group_TourDuration'),
            new AggregateAttribute('remark', GroupRemark::class, 'Group_Remark'),
            new AggregateAttribute('masterType', GroupMasterType::class, 'Group_MasterType'),
            new AggregateAttribute('serviceType', GroupServiceType::class, 'Group_ServiceType'),
            new AggregateAttribute('noValidPassengers', GroupNoValidPassengers::class, 'Group_NoValidPassengers'),
            new AggregateAttribute('validPassengers', GroupValidPassengers::class, 'Group_ValidPassengers'),
            new AggregateAttribute('status', GroupStatus::class, 'Group_Status'),
            new AggregateAttribute('idMaster', IdGroup::class, 'Id_Master'),
            new AggregateAttribute('idService', IdGroupService::class, 'Id_Service'),
            new AggregateAttribute('idStatusGroup', IdStatusGroup::class, 'Id_StatusGroup'),
        ];
    }

    protected static function table(): string
    {
        return 't_booking';
    }

    public function __construct(
        protected IdGroup $id,
        protected GroupDate $date,
        protected GroupDateUpdate $dateUpdate,
        protected GroupDateStart $dateStart,
        protected GroupDateEnd $dateEnd,
        protected GroupHour $hour,
        protected GroupName $name,
        protected GroupToken $token,
        protected GroupOrigin $origin,
        protected GroupDestination $Destination,
        protected GroupType $type,
        protected GroupOrder $order,
        protected GroupTourDuration $tourDuration,
        protected GroupRemark $remark,
        protected GroupMasterType $masterType,
        protected GroupServiceType $serviceType,
        protected GroupNoValidPassengers $noValidPassengers,
        protected GroupValidPassengers $validPassengers,
        protected GroupStatus $status,
        protected IdGroup $idMaster,
        protected IdGroupService $idService,
        protected IdStatusGroup $idStatusGroup,
    ) {}

    public function id(): IdGroup
    {
        return $this->id;
    }

    public function date(): GroupDate
    {
        return $this->date;
    }

    public function dateUpdate(): GroupDateUpdate
    {
        return $this->dateUpdate;
    }

    public function dateStart(): GroupDateStart
    {
        return $this->dateStart;
    }

    public function dateEnd(): GroupDateEnd
    {
        return $this->dateEnd;
    }

    public function hour(): GroupHour
    {
        return $this->hour;
    }

    public function name(): GroupName
    {
        return $this->name;
    }

    public function token(): GroupToken
    {
        return $this->token;
    }

    public function origin(): GroupOrigin
    {
        return $this->origin;
    }

    public function Destination(): GroupDestination
    {
        return $this->Destination;
    }

    public function type(): GroupType
    {
        return $this->type;
    }

    public function order(): GroupOrder
    {
        return $this->order;
    }

    public function tourDuration(): GroupTourDuration
    {
        return $this->tourDuration;
    }

    public function remark(): GroupRemark
    {
        return $this->remark;
    }

    public function masterType(): GroupMasterType
    {
        return $this->masterType;
    }

    public function serviceType(): GroupServiceType
    {
        return $this->serviceType;
    }

    public function noValidPassengers(): GroupNoValidPassengers
    {
        return $this->noValidPassengers;
    }

    public function validPassengers(): GroupValidPassengers
    {
        return $this->validPassengers;
    }

    public function status(): GroupStatus
    {
        return $this->status;
    }

    public function idMaster(): IdGroup
    {
        return $this->idMaster;
    }

    public function idService(): IdGroupService
    {
        return $this->idService;
    }

    public function idStatusGroup(): IdStatusGroup
    {
        return $this->idStatusGroup;
    }
}
