<?php

namespace App\Modules\Group\Domain;

class CreateGroup
{
    public function __construct(
        private GroupDateStart $dateStart,
        private GroupHour $hour,
        private GroupOrigin $origin,
        private GroupDestination $destination,
        private GroupType $type,
        private GroupRemark $remark,
        private GroupServiceType $serviceType,
        private GroupIdService $idService,
    ) {
    }

    public function dateStart(): GroupDateStart
    {
        return $this->dateStart;
    }

    public function hour(): GroupHour
    {
        return $this->hour;
    }

    public function origin(): GroupOrigin
    {
        return $this->origin;
    }

    public function destination(): GroupDestination
    {
        return $this->destination;
    }

    public function type(): GroupType
    {
        return $this->type;
    }

    public function remark(): GroupRemark
    {
        return $this->remark;
    }

    public function serviceType(): GroupServiceType
    {
        return $this->serviceType;
    }

    public function idService(): GroupIdService
    {
        return $this->idService;
    }
}
