<?php

namespace App\Modules\Group\Application\ValidatePassengers;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Bus\Command\CommandHandler;

final class GroupPassengersValidationHandler implements CommandHandler
{
    public function __construct(private GroupPassengersValidator $validator)
    {
    }

    public function __invoke(GroupPassengersValidationCommand $query)
    {
        return $this->validator->__invoke(new IdGroup($query->idGroup()));
    }
}
