<?php

namespace App\Modules\Group\Application\UpdateStatus;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\StatusGroup\Domain\IdStatusGroup;

final class UpdateGroupStatusQueryHandler implements QueryHandler
{
    public function __construct(private GroupStatusGroupUpdater $updater)
    {
    }

    public function __invoke(UpdateGroupStatusQuery $query): UpdateGroupStatusQueryResponse
    {
        return $this->updater->__invoke(new IdGroup($query->idGroup()), new IdStatusGroup($query->idStatusGroup()));
    }
}
