<?php

namespace App\Modules\Group\Application\Create;

use App\Modules\Group\Domain\CreateGroup;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Group\Domain\GroupDestination;
use App\Modules\Group\Domain\GroupHour;
use App\Modules\Group\Domain\GroupIdService;
use App\Modules\Group\Domain\GroupOrigin;
use App\Modules\Group\Domain\GroupRemark;
use App\Modules\Group\Domain\GroupServiceType;
use App\Modules\Group\Domain\GroupType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateGroupQueryHandler implements QueryHandler
{
    public function __construct(private GroupCreator $creator)
    {
    }

    public function __invoke(CreateGroupQuery $query): CreateGroupResponse
    {
        $model = new CreateGroup(
            new GroupDateStart($query->dateStart()),
            new GroupHour($query->hour()),
            new GroupOrigin($query->origin()),
            new GroupDestination($query->destination()),
            new GroupType($query->type()),
            new GroupRemark($query->remark()),
            new GroupServiceType($query->serviceType()),
            new GroupIdService($query->idService()),
        );
        return $this->creator->__invoke($model);
    }
}
