<?php

namespace App\Modules\Flight\Application\Insert;

use App\Modules\Flight\Domain\Flight;
use App\Modules\Flight\Domain\FlightRepository;

final class FlightInserter
{
  public function __construct(private FlightRepository $repository) {}

  public function __invoke(Flight $flight): InsertFlightResponse
  {
    return new InsertFlightResponse($this->repository->insert($flight));
  }
}
