<?php

namespace App\Modules\FactUnit\Application\Update;

use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\FactUnit\Domain\FactUnit;
use App\Modules\FactUnit\Domain\FactUnitAbrv;
use App\Modules\FactUnit\Domain\FactUnitName;
use App\Modules\FactUnit\Domain\FactUnitStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactUnitUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private FactUnitUpdater $updater)
    {
    }

    public function __invoke(FactUnitUpdaterQuery $query): FactUnitUpdaterResponse
    {
        $model = new FactUnit(
            new IdFactUnit($query->getId()),
            new FactUnitName($query->getName()),
            new FactUnitAbrv($query->getAbrv()),
            new FactUnitStatus($query->getStatus()),
        );
        return $this->updater->__invoke($model);
    }
}
