<?php

namespace App\Modules\FactUnit\Application\Update;

use App\Modules\FactUnit\Application\Update\FactUnitUpdaterResponse;
use App\Modules\FactUnit\Domain\FactUnit;
use App\Modules\FactUnit\Domain\FactUnitRepository;

final class FactUnitUpdater
{
    public function __construct(private FactUnitRepository $repository)
    {
    }

    public function __invoke(FactUnit $lead): FactUnitUpdaterResponse
    {
        return new FactUnitUpdaterResponse($this->repository->update($lead));
    }
}
