<?php

namespace App\Modules\FactTypeReceipt\Application\Update;

use App\Modules\FactTypeReceipt\Application\Update\FactTypeReceiptUpdaterResponse;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceipt;
use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptRepository;

final class FactTypeReceiptUpdater
{
    public function __construct(private FactTypeReceiptRepository $repository)
    {
    }

    public function __invoke(FactTypeReceipt $lead): FactTypeReceiptUpdaterResponse
    {
        return new FactTypeReceiptUpdaterResponse($this->repository->update($lead));
    }
}
