<?php

namespace App\Modules\FactTypeOperation\Infraestructure;

use App\Modules\FactTypeOperation\Domain\FactTypeOperation;
use App\Modules\FactTypeOperation\Domain\FactTypeOperationRepository;
use App\Modules\FactTypeOperation\Domain\IdFactTypeOperation;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlFactTypeOperationRepository implements FactTypeOperationRepository
{

    public function find(StorageCriteria $criteria): FactTypeOperation
    {
        return FactTypeOperation::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => FactTypeOperation::fromDTO($btp), $criteria->run());
    }

    public function insert(FactTypeOperation $value)
    {
        return Requester::requestInsert(
            'CALL sp_fact_type_operation_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->abrv()->value(),
                $value->status()->value()
            ]
        );
    }

    public function update(FactTypeOperation $value)
    {
        return Requester::requestUpdate(
            'CALL sp_fact_type_operation_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->abrv()->value(),
                $value->status()->value(),
            ]
        );
    }
}
