<?php

namespace App\Modules\FactReceiptDetail\Application\Create;

use App\Modules\FactReceiptDetail\Domain\FactReceiptDetail;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailRepository;

final class FactReceiptDetailCreator
{
    public function __construct(private FactReceiptDetailRepository $repository)
    {
    }

    public function __invoke(FactReceiptDetail $factReceipt): CreateFactReceiptDetailResponse
    {
        return new CreateFactReceiptDetailResponse($this->repository->insert($factReceipt));
    }
}
