<?php

namespace App\Modules\FactReceipt\Application\Send;

use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class SendFactReceiptQueryHandler implements QueryHandler
{
    public function __construct(
        private FactReceiptSender $sender,
    ) {
    }

    public function __invoke(SendFactReceiptQuery $query): SendFactReceiptResponse
    {
        return new SendFactReceiptResponse($this->sender->__invoke(new IdFactReceipt($query->id())));
    }
}
