<?php

namespace App\Modules\FactProduct\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFactProduct implements StorageCriteria
{

    public function __construct(private string $action) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactProduct::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`FactProduct_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`FactProduct_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`FactProduct_Status` = 0';
        } else {
            $where = '`ftd`.`FactProduct_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_fact_product` `ftd`
            WHERE $where",
            [ ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
