<?php

namespace App\Modules\FactPaymentMethod\Infrastructure;

use App\Modules\FactPaymentMethod\Domain\FactPaymentMethod;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodRepository;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;

class MysqlFactPaymentMethodRepository implements FactPaymentMethodRepository
{

    public function find(StorageCriteria $criteria): FactPaymentMethod | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return FactPaymentMethod::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => FactPaymentMethod::fromDTO($btp), $criteria->run());
    }

    public function insert(FactPaymentMethod $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(FactPaymentMethod $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
