<?php

namespace App\Modules\FactPaymentMethod\Application\Index;

use App\Modules\FactPaymentMethod\Domain\IdFactPaymentMethod;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodRepository;
use App\Modules\FactPaymentMethod\Domain\IndexFactPaymentMethod;

final class FactPaymentMethodIndexer
{
    public function __construct(private FactPaymentMethodRepository $repository)
    {
    }

    public function __invoke(IdFactPaymentMethod $idFactPaymentMethod, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexFactPaymentMethod($idFactPaymentMethod, $lockInShare));
        return $index;
    }
}
