<?php

namespace App\Modules\FactPaymentMethod\Application\Delete;

use App\Modules\FactPaymentMethod\Domain\IdFactPaymentMethod;
use App\Modules\FactPaymentMethod\Application\Index\FactPaymentMethodIndexer;
use App\Modules\FactPaymentMethod\Application\Update\FactPaymentMethodUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteFactPaymentMethodQueryHandler implements QueryHandler
{
    public function __construct(
        private FactPaymentMethodUpdater $update,
        private FactPaymentMethodIndexer $indexer
    ) {
    }

    public function __invoke(DeleteFactPaymentMethodQuery $query): DeleteFactPaymentMethodResponse
    {
        $index = $this->indexer->__invoke(new IdFactPaymentMethod($query->idFactPaymentMethod()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteFactPaymentMethodResponse();
    }
}
