<?php

namespace App\Modules\FactCurrency\Application\Update;

use App\Modules\FactCurrency\Application\Index\FactCurrencyIndexer;
use App\Modules\FactCurrency\Domain\IdFactCurrency;
use App\Modules\FactCurrency\Domain\FactCurrencyAbrv;
use App\Modules\FactCurrency\Domain\FactCurrencyName;
use App\Modules\FactCurrency\Domain\FactCurrencyStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateFactCurrencyQueryHandler implements QueryHandler
{
    public function __construct(
        private FactCurrencyUpdater $updater,
        private FactCurrencyIndexer $indexer
    ) {
    }

    public function __invoke(UpdateFactCurrencyQuery $query): UpdateFactCurrencyResponse
    {
        $index = $this->indexer->__invoke(new IdFactCurrency($query->id()), true);
        $index->setName(new FactCurrencyName($query->name()));
        $index->setAbrv(new FactCurrencyAbrv($query->abrv()));
        $index->setStatus(new FactCurrencyStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateFactCurrencyResponse();
    }
}
