<?php

namespace App\Modules\ExternalUserPassenger\Infraestructure;

use App\Modules\ExternalUserPassenger\Domain\HCHtlUsageDateUsage;
use App\Modules\ExternalUserPassenger\Domain\ExternalUserPassenger;
use App\Modules\ExternalUserPassenger\Domain\ExternalUserPassengerRepository;
use App\Modules\ExternalUserPassenger\Domain\IdExternalUserPassenger;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlExternalUserPassengerRepository implements ExternalUserPassengerRepository
{

    public function find($IdExternalUser, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_external_user_passenger_list(?,?,@sts,@cod,@msg)',
            [
                $IdExternalUser,
                $action
            ]
        );
    }

    public function index(IdExternalUserPassenger $id)
    {
        return Requester::requestSelect(
            'CALL sp_external_user_passenger_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(ExternalUserPassenger $value)
    {
        return Requester::requestInsert(
            'CALL sp_external_user_passenger_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getStatus()->value(),
                $value->getIdExternalUser()->value(),
                $value->getIdPassenger()->value(),
            ]
        );
    }

    public function update(ExternalUserPassenger $value)
    {
        return Requester::requestUpdate(
            'CALL sp_external_user_passenger_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getStatus()->value(),
                $value->getIdExternalUser()->value(),
                $value->getIdPassenger()->value(),
            ]
        );
    }

    public function delete(IdExternalUserPassenger $id)
    {
        return Requester::requestUpdate(
            'CALL sp_external_user_passenger_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
