<?php

namespace App\Modules\ExternalApiRequest\Application\Create;

use App\Modules\ExternalApiRequest\Domain\ExternalApiRequest;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestRepository;

final class ExternalApiRequestCreator
{
    public function __construct(private ExternalApiRequestRepository $repository)
    {
    }

    public function __invoke(ExternalApiRequest $model)
    {
        return $this->repository->insert($model);
    }
}
