<?php

namespace App\Modules\EmailShip\Infraestructure;

use App\Modules\EmailShip\Domain\EmailShipRepository;
use App\Modules\EmailShip\Domain\IdEmailShip;
use App\Modules\EmailShip\Domain\InsertEmailShip;
use App\Modules\EmailShip\Domain\UpdateEmailShip;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlEmailShipRepository implements EmailShipRepository
{
    public function find(string $query, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_email_ship_list(?,?,@sts,@cod,@msg)',
            [
                $query,
                $action
            ]
        );
    }

    public function index(IdEmailShip $id)
    {
        return Requester::requestSelect(
            'CALL sp_email_ship_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(InsertEmailShip $value)
    {
        return Requester::requestInsert(
            'CALL sp_email_ship_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getTo()->value(),
                $value->getBcc()->value(),
                $value->getStatus()->value()
            ]
        );
    }

    public function update(UpdateEmailShip $value)
    {
        return Requester::requestUpdate(
            'CALL sp_email_ship_update(?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getStatus()->value(),
                $value->getResponse()->value(),
            ]
        );
    }

    public function delete(IdEmailShip $id)
    {
        return Requester::requestUpdate(
            'CALL sp_email_ship_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
