<?php

namespace App\Modules\EmailShip\Application;

use App\Modules\EmailShip\Domain\EmailShipRepository;
use App\Modules\EmailShip\Domain\EmailShipShippedRepository;
use Illuminate\Contracts\Mail\Mailable;

class EmailShipShipper
{

    public function __construct(
        private EmailShipShippedRepository $repository,
        private EmailShipRepository $emailShipRepo
    ) {
    }

    public function __invoke(array $email, array $bcc, array $replyTo, Mailable $mail)
    {
        $builder = new EmailShipBuilder();
        return $this->repository->ship(
            $builder($email),
            $builder($bcc),
            $builder($replyTo),
            $mail,
            new EmailShipInserter($this->emailShipRepo),
            new EmailShipUpdater($this->emailShipRepo)
        );
    }
}
