<?php

namespace App\Modules\Credential\Domain;

final class Credential
{
    public const PUBLIC_KEYS = [
        'Paypal',
        'Tax',
        'Web_URL',
        'Resources_URL',
        'Terms_URL',
        'Niubiz_Auth',
        'Niubiz_AccessToken',
        'Niubiz_MerchantId',
        'Client_Web_Url',
        'Config_Fee',
        'Internal_Web_URL',
        'TripAdvisor_Bias',
        'Departure_Order_Message'
    ];

    public static function getPublic($list)
    {
        $found = [];
        foreach ($list as $element)
        {
            if (in_array($element->Credential_key, self::PUBLIC_KEYS)) {
                $found[] = $element;
            }
        }
        return $found;
    }
}