<?php

namespace App\Modules\CategoryTour\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class CategoryTour extends AggregateRoot
{
    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdCategoryTour::class, 'Id_CategoryTour'),
            new AggregateAttribute('name', CategoryTourName::class, 'CategoryTour_Name'),
            new AggregateAttribute('status', CategoryTourStatus::class, 'CategoryTour_Status'),
        ];
    }

    /** constructor */
    public function __construct(
        private IdCategoryTour $id,
        private CategoryTourName $name,
        private CategoryTourStatus $status,
    ) {}

    public function value()
    {
        return [
            'Id_CategoryTour' => $this->id->value(),
            'CategoryTour_Name' => $this->name->value(),
            'CategoryTour_Status' => $this->status->value(),
        ];
    }

    public function id(): IdCategoryTour
    {
        return $this->id;
    }

    public function name(): CategoryTourName
    {
        return $this->name;
    }

    public function status(): CategoryTourStatus
    {
        return $this->status;
    }
}
