<?php

namespace App\Modules\CashMovementFactReceipt\Domain;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class CurrentCashMovementFactReceipt implements StorageCriteria
{

    public function __construct(
        private IdCashMovement $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = CashMovementFactReceipt::select('`cmfr`');
        return DB::select(
            "SELECT $select
            FROM `t_cash_movement_fact_receipt` `cmfr`
            WHERE `cmfr`.`Id_CashMovement` = ?
            AND `cmfr`.`CashMovementFactReceipt_Status` = ?",
            [
                $this->id->value(),
                CashMovementFactReceiptStatus::ACTIVE
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            return null;
        }
        return $data[0];
    }
}
