<?php

namespace App\Modules\CashMovementDetail\Application\List;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovementDetail\Domain\CashMovementDetailRepository;

final class CashMovementDetailLister
{
    public function __construct(private CashMovementDetailRepository $repository)
    {
    }

    public function __invoke(IdCashMovement $idCashMovement, string $action): ListCashMovementDetailResponse
    {
        return new ListCashMovementDetailResponse($this->repository->list($idCashMovement, $action));
    }
}
