<?php

namespace App\Modules\CalendarTour\Application\ListPassengerAlter;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;

final class ListPassengerAlterCalendarTourQueryHandler implements QueryHandler
{
    public function __construct(private CalendarTourAlterPassengerLister $lister)
    {
    }

    public function __invoke(ListPassengerAlterCalendarTourQuery $query): ListPassengerAlterCalendarTourResponse
    {
        return $this->lister->__invoke(
            new IdTour($query->idTour()),
            new DateStart($query->dateStart())
        );
    }
}
