<?php

namespace App\Modules\Briefing\Domain;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListBookingTourPassengerBriefing implements StorageCriteria
{

    public function __construct(
        private DateTimeStart $dateTimeStart,
        private DateTimeEnd $dateTimeEnd,
        private BriefingType $type,
        private BriefingOrderBy $orderBy,
        private IdBookingTour $idBookingTour,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $lockInShare = $this->lockInShare ? 'LOCK IN SHARE MODE' : '';
        if ($this->type->value() === 'all') {
            $typeWhere = '1';
        } else if ($this->type->value() === 'ontime') {
            $typeWhere = "`bt`.`BookingTour_DateStart` = DATE_ADD(CONVERT(`bt`.`BookingTour_DateBriefing`, DATE), INTERVAL 1 DAY)";
        } else {
            $typeWhere = "`bt`.`BookingTour_DateStart` <> DATE_ADD(CONVERT(`bt`.`BookingTour_DateBriefing`, DATE), INTERVAL 1 DAY)";
        }

        if ($this->orderBy->value() === 'dateStart') {
            $orderBy = "`bt`.`BookingTour_DateStart` BETWEEN ? AND ?";
        } else {
            $orderBy = "`bt`.`BookingTour_DateBriefing` BETWEEN ? AND ?";
        }

        return DB::select(
            "SELECT `p`.`Id_Passenger`,
                    `p`.`Passenger_Name`,
                    `p`.`Passenger_LastName`,
                    `p`.`Passenger_Email`,
                    `p`.`Passenger_Phone`,
                    `p`.`Passenger_PhoneCode`,
                    `p`.`Passenger_Gender`,
                    `p`.`Passenger_DOB`,
                    `p`.`Passenger_NoDocument`,

                    `uc`.`Id_UserCountry`,
                    `uc`.`UserCountry_Name`,
                    `uc`.`UserCountry_Img`,
                    '" . config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB') . "' AS `UserCountry_Path`,

                    `btp`.`Id_BookingTourPassenger`,
                    `btp`.`BookingTourPassenger_Status`,
                    `btp`.`BookingTourPassenger_PaymentStatus`,

                    `bt`.`Id_BookingTour`,
                    `bt`.`BookingTour_DateStart`,
                    `bt`.`BookingTour_PickUp`,
                    `bt`.`BookingTour_Type`,
                    `bt`.`BookingTour_NoPax`,
                    `bt`.`BookingTour_Name`,
                    `bt`.`BookingTour_TourName`,
                    `bt`.`BookingTour_FeeType`,
                    `bt`.`BookingTour_Full`,
                    `bt`.`BookingTour_MinimumFull`,
                    `bt`.`BookingTour_Group`,
                    `bt`.`BookingTour_TourDuration`,
                    `bt`.`BookingTour_DateBriefing`,
                    `bt`.`BookingTour_PlaceBriefing`,
                    `bt`.`BookingTour_UseBookingPlaceBriefing`,
                    `bt`.`BookingTour_Status`,
                    `b`.`Id_Booking`,
                    `b`.`Booking_Code`,
                    `bt`.`Id_Package`,
                    `bt`.`Id_Tour`,
                    0 AS `Id_Group`
                FROM `t_booking_tour_passenger` `btp`
                INNER JOIN `t_passenger` `p` ON `p`.`Id_Passenger` = `btp`.`Id_Passenger`
                INNER JOIN `t_user_country` `uc` ON `uc`.`Id_UserCountry` = `p`.`Id_UserCountry`
                INNER JOIN `t_booking_tour` `bt` ON `bt`.`Id_BookingTour` = `btp`.`Id_BookingTour`
                INNER JOIN `t_booking` `b` ON `b`.`Id_Booking` = `bt`.`Id_Booking`
                LEFT JOIN `t_group_passenger` `gp` ON `gp`.`Id` = `btp`.`Id_BookingTourPassenger`
                    AND `gp`.`GroupPassenger_Type` = 1
                WHERE $orderBy
                AND $typeWhere
                AND `gp`.`Id_GroupPassenger` IS NULL
                AND `btp`.`BookingTourPassenger_Status` = 2 AND
                `bt`.`BookingTour_Status` = 2 AND
                `fn_booking_tour_passenger_check`(
                    `b`.`Booking_Status`,
                    `b`.`Booking_ManuallyConfirmed`,
                    1,
                    1,
                    `btp`.`BookingTourPassenger_PaymentStatus`
                )
                AND `bt`.`Id_BookingTour` = ?",
            [
                $this->dateTimeStart->value(),
                $this->dateTimeEnd->value(),
                $this->idBookingTour->value()
            ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
