<?php

namespace App\Modules\Briefing\Application\ListBookingTourPassenger;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Briefing\Domain\BriefingOrderBy;
use App\Modules\Briefing\Domain\BriefingRepository;
use App\Modules\Briefing\Domain\BriefingType;
use App\Modules\Briefing\Domain\ListBookingTourPassengerBriefing;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class BriefingBookingTourPassengerLister
{
    public function __construct(private BriefingRepository $repository)
    {
    }

    public function __invoke(
        DateTimeStart $dateTimeStart,
        DateTimeEnd $dateTimeEnd,
        BriefingType $type,
        BriefingOrderBy $orderBy,
        IdBookingTour $idBookingTour
    )
    {
        return $this->repository->search(new ListBookingTourPassengerBriefing(
            $dateTimeStart,
            $dateTimeEnd,
            $type,
            $orderBy,
            $idBookingTour,
            false
        ));
    }
}
