<?php

namespace App\Modules\BookingUpgradePassenger\Application\Mask;

use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerMask;
use App\Modules\BookingUpgradePassenger\Domain\IdBookingUpgradePassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class MaskBookingUpgradePassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingUpgradePassengerMasker $masker)
    {
    }

    public function __invoke(MaskBookingUpgradePassengerQuery $query): MaskBookingUpgradePassengerResponse
    {
        return $this->masker->__invoke(
            new IdBookingUpgradePassenger($query->id()),
            new BookingUpgradePassengerMask($query->mask())
        );
    }
}
