<?php

namespace App\Modules\BookingTourPassenger\Domain;

use Illuminate\Support\Facades\DB;

class IndexBookingTourPassenger
{

    public function __construct(
        private IdBookingTourPassenger $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        return DB::select(
            'SELECT `Id_BookingTourPassenger`,
                    `BookingTourPassenger_Lock`,
                    `BookingTourPassenger_Reportable`,
                    `BookingTourPassenger_Hotel`,
                    `BookingTourPassenger_Remark`,
                    `BookingTourPassenger_Price`,
                    `BookingTourPassenger_Full`,
                    `BookingTourPassenger_ValidGroups`,
                    `BookingTourPassenger_NoValidGroups`,
                    `BookingTourPassenger_Status`,
                    `BookingTourPassenger_PaymentStatus`,
                    `Id_BookingTour`,
                    `Id_Passenger`
            FROM `t_booking_tour_passenger`
            WHERE `Id_BookingTourPassenger` = ?',
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new BookingTourPassengerNotFound();
        }
        return $data[0];
    }
}
