<?php

namespace App\Modules\BookingTourPassenger\Application\ChangeStatus;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRepository;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;

final class BookingTourPassengerStatusChanger
{
    public function __construct(
        private BookingTourPassengerRepository $repository
    ) {
    }

    public function __invoke(
        IdBookingTourPassenger $id,
    ): ChangeStatusBookingTourPassengerResponse {
        return new ChangeStatusBookingTourPassengerResponse($this->repository->cancel($id));
    }
}
