<?php

namespace App\Modules\BookingTourItem\Application\List;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourItem\Application\ListEquipment\EquipmentLister;
use App\Modules\BookingTourItem\Application\ListExtra\ExtraLister;
use App\Modules\BookingTourItem\Application\ListUpgrade\UpgradeLister;
use App\Modules\BookingTourItem\Domain\ItemType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class BookingTourItemListerQueryHandler implements QueryHandler
{
    public function __construct(
        private UpgradeLister $upgradeLister,
        private ExtraLister $extraLister,
        private EquipmentLister $equipmentLister,
    ) {
    }

    public function __invoke(BookingTourItemListerQuery $query): BookingTourItemListerResponse
    {
        switch($query->getItemType()) {
            case ItemType::UPGRADE:
                return $this->upgradeLister->__invoke(
                    new IdBookingTour($query->getIdBookingTour()),
                    $query->getAction()
                );
            case ItemType::EXTRA:
                return $this->extraLister->__invoke(
                    new IdBookingTour($query->getIdBookingTour()),
                    $query->getAction()
                );
            case ItemType::EQUIPMENT:
                return $this->equipmentLister->__invoke(
                    new IdBookingTour($query->getIdBookingTour()),
                    $query->getAction()
                );
        }
        
    }
}
