<?php

namespace App\Modules\BookingTour\Application\Find;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FindBookingTourQueryHandler implements QueryHandler
{
    public function __construct(private BookingTourFinder $changer)
    {
    }

    public function __invoke(FindBookingTourQuery $query): FindBookingTourResponse
    {
        return $this->changer->__invoke(
            new IdBookingTour($query->id())
        );
    }
}
