<?php

namespace App\Modules\BookingTour\Application\Find;

use App\Modules\BookingTour\Domain\BookingTourRepository;
use App\Modules\BookingTour\Domain\IdBookingTour;

final class BookingTourFinder
{
    public function __construct(
        private BookingTourRepository $repository
    ) {
    }

    public function __invoke(
        IdBookingTour $id,
    ): FindBookingTourResponse {
        return new FindBookingTourResponse($this->repository->index($id));
    }
}
