<?php

namespace App\Modules\BookingReferredFrom\Domain;

class BookingReferredFrom {

    private BookingReferredFromName $name;
    private BookingReferredFromAbrv $abrv;
    private BookingReferredFromStatus $status;
    private BookingReferredFromLock $lock;
    private ?IdBookingReferredFrom $id;

    /** constructor */
    public function __construct (
        BookingReferredFromName $name,
        BookingReferredFromAbrv $abrv,
        BookingReferredFromLock $lock,
        BookingReferredFromStatus $status,
        ?IdBookingReferredFrom $id = NULL
    ) {
        $this->name = $name;
        $this->abrv = $abrv;
        $this->lock = $lock;
        $this->status = $status;
        $this->id = $id;
    }


    public function getName():BookingReferredFromName { return $this->name; }
    public function getAbrv():BookingReferredFromAbrv { return $this->abrv; }
    public function getLock():BookingReferredFromLock { return $this->lock; }
    public function getStatus():BookingReferredFromStatus { return $this->status; }
    public function getId():IdBookingReferredFrom { return $this->id; }
}