<?php

namespace App\Modules\BookingExtraPassenger\Application\ListById;

use App\Modules\BookingExtraPassenger\Application\BookingExtraPassengerResponse;
use App\Modules\BookingExtraPassenger\Application\BookingExtraPassengerResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListByIdBookingExtraPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingExtraPassengerByIdLister $lister)
    {
    }

    public function __invoke(ListByIdBookingExtraPassengerQuery $query): BookingExtraPassengerResponses
    {
        return new BookingExtraPassengerResponses(...array_map(
            fn ($index) => new BookingExtraPassengerResponse(
                $index->id()->value(),
                $index->date()->value(),
                $index->dateEntryStart()->value(),
                $index->dateEntryEnd()->value(),
                $index->datePurchase()->value(),
                $index->code()->value(),
                $index->amount()->value(),
                $index->remark()->value(),
                $index->status()->value(),
                $index->idAdmin()->value(),
                $index->idBookingExtra()->value(),
                $index->idBookingTourPassenger()->value(),
                $index->idPassenger()->value(),
                $index->passengerGender()->value(),
                $index->passengerName()->value(),
                $index->passengerLastName()->value(),
                $index->idBookingTour()->value(),
                $index->bookingTourTourName()->value(),
                $index->bookingTourDateStart()->value(),
                $index->bookingTourTourDuration()->value(),
                $index->idBooking()->value(),
                $index->bookingCode()->value(),
                $index->bookingInternalRemark()->value(),
                $index->bookingObservation()->value(),
                $index->idUserCountry()->value(),
                config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB') . $index->userCountryImg()->value(),
                $index->userCountryName()->value()
            ),
            $this->lister->__invoke($query->ids())
        ));
    }
}
