<?php

namespace App\Modules\BookingCalendar\Infrastructure;

use App\Modules\BookingCalendar\Domain\BookingCalendarRepository;
use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\Requester;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\TypeTour\Domain\IdTypeTour;

class MysqlBookingCalendarRepository implements BookingCalendarRepository
{
    public function tourList(
        IdCategoryTour $idCategoryTour,
        IdTypeTour $idTypeTour,
        IdTour $idTour,
        IdPackage $idPackage,
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $token
    ) {
        return Requester::requestSelect(
            'CALL sp_booking_calendar_tour_list(?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $idTour->value(),
                $idTypeTour->value(),
                $idCategoryTour->value(),
                $idPackage->value(),
                $dateStart->value(),
                $dateEnd->value(),
                $token
            ]
        );
    }
    public function tourPassengerList(
        IdTour $idTour,
        DateStart $dateStart
    ) {
        return Requester::requestSelect(
            'CALL sp_booking_calendar_tour_passenger_list(?,?,?,@sts,@cod,@msg)',
            [
                $idTour->value(),
                config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB'),
                $dateStart->value()
            ]
        );
    }
}
