<?php

namespace App\Modules\BookingAssign\Application\Update;

use App\Modules\BookingAssign\Application\Update\UpdateBookingAssignQueryResponse;
use App\Modules\BookingAssign\Domain\BookingAssign;
use App\Modules\BookingAssign\Domain\BookingAssignRepository;
use App\Modules\BookingAssign\Domain\UpdateBookingAssign;

final class BookingAssignUpdater
{
    public function __construct(private BookingAssignRepository $repository)
    {
    }

    public function __invoke(UpdateBookingAssign $bookingAssign): UpdateBookingAssignQueryResponse
    {
        return new UpdateBookingAssignQueryResponse($this->repository->update($bookingAssign));
    }
}
