<?php

namespace App\Modules\BookingAssign\Application\Delete;

use App\Modules\BookingAssign\Domain\IdBookingAssign;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private BookingAssignDeleter $inserter)
    {
    }

    public function __invoke(DeleteBookingAssignQuery $query): DeleteBookingAssignQueryResponse
    {
        return $this->inserter->__invoke(new IdBookingAssign($query->getId()));
    }
}
