<?php

namespace App\Modules\BookingAdditional\Application\CreateFromBookingExtraPassenger;

use App\Modules\BookingAdditional\Application\Create\BookingAdditionalCreator;
use App\Modules\BookingAdditional\Application\Create\CreateBookingAdditionalResponse;
use App\Modules\BookingAdditional\Domain\IdBookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditionalAbrv;
use App\Modules\BookingAdditional\Domain\BookingAdditionalName;
use App\Modules\BookingAdditional\Domain\BookingAdditionalStatus;
use App\Modules\BookingAdditional\Domain\BookingAdditionalType;
use App\Modules\BookingAdditional\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\BookingExtraPassenger\Application\Index\IndexBookingExtraPassengerQuery;
use App\Modules\BookingExtraPassenger\Application\Index\IndexBookingExtraPassengerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateFromBookingExtraPassengerBookingAdditionalQueryHandler implements QueryHandler
{
    public function __construct(
        private BookingAdditionalCreator $creator,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(CreateFromBookingExtraPassengerBookingAdditionalQuery $query): CreateBookingAdditionalResponse
    {
        /** @var IndexBookingExtraPassengerResponse $index */
        $index = $this->queryBus->ask(new IndexBookingExtraPassengerQuery($query->idInternal()));
        $model = new BookingAdditional(
                new IdBookingAdditional(0),
                new BookingAdditionalName($index->response()[0]->Extra_Name),
                new BookingAdditionalAbrv($index->response()[0]->Extra_Code),
                new BookingAdditionalType(BookingAdditionalType::BOOKING_EXTRA_PASSENGER),
                new BookingAdditionalStatus(BookingAdditionalStatus::ACTIVE),
                new IdBookingTourPassenger($index->response()[0]->Id_BookingTourPassenger),
                new Id($index->response()[0]->Id_BookingExtraPassenger),
            );
        return $this->creator->__invoke($model);
    }
}
