<?php

namespace App\Modules\Booking\Application\SearchConfirm;

use App\Modules\Booking\Domain\BookingRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class BookingConfirmSearcher
{
    public function __construct(private BookingRepository $repository)
    {
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $orderBy
    ): SearchConfirmBookingResponse {
        return new SearchConfirmBookingResponse($this->repository->searchConfirm(
            $dateStart,
            $dateEnd,
            $orderBy
        ));
    }
}
