<?php

namespace App\Modules\Booking\Application\Report\SalesByPackage;

use Illuminate\Support\Facades\DB;

final class BookingSalesByTourReporter
{
    public function __construct()
    {
    }

    public function __invoke($dateStart, $dateEnd, $limit)
    {
        // $orderBy = '`b`.`Booking_DateConfirm`';
        $orderBy = '`bt`.`BookingTour_DateStart`';
        return DB::select(
            "SELECT
                `aux`.`Passenger_Age`,
                COUNT(DISTINCT `Id_Passenger`) AS `Pax Amount`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-01-01 00:00:00' AND DATE_SUB('2023-02-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Enero`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-02-01 00:00:00' AND DATE_SUB('2023-03-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Febrero`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-03-01 00:00:00' AND DATE_SUB('2023-04-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Marzo`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-04-01 00:00:00' AND DATE_SUB('2023-05-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Abril`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-05-01 00:00:00' AND DATE_SUB('2023-06-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Mayo`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-06-01 00:00:00' AND DATE_SUB('2023-07-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Junio`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-07-01 00:00:00' AND DATE_SUB('2023-08-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Julio`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-08-01 00:00:00' AND DATE_SUB('2023-09-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Agosto`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-09-01 00:00:00' AND DATE_SUB('2023-10-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Setiembre`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-10-01 00:00:00' AND DATE_SUB('2023-11-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Octubre`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-11-01 00:00:00' AND DATE_SUB('2023-12-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Noviembre`,
                COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-12-01 00:00:00' AND DATE_SUB('2024-01-01 23:59:59', INTERVAL 1 DAY), `Id_Passenger`, NULL)) AS `Pax Amount Diciembre`,
            
                 COUNT(DISTINCT `Id_Booking`) AS `Amount`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-01-01 00:00:00' AND DATE_SUB('2023-02-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Enero`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-02-01 00:00:00' AND DATE_SUB('2023-03-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Febrero`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-03-01 00:00:00' AND DATE_SUB('2023-04-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Marzo`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-04-01 00:00:00' AND DATE_SUB('2023-05-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Abril`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-05-01 00:00:00' AND DATE_SUB('2023-06-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Mayo`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-06-01 00:00:00' AND DATE_SUB('2023-07-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Junio`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-07-01 00:00:00' AND DATE_SUB('2023-08-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Julio`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-08-01 00:00:00' AND DATE_SUB('2023-09-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Agosto`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-09-01 00:00:00' AND DATE_SUB('2023-10-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Setiembre`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-10-01 00:00:00' AND DATE_SUB('2023-11-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Octubre`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-11-01 00:00:00' AND DATE_SUB('2023-12-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Noviembre`,
                 COUNT(DISTINCT IF(`Booking_DateConfirm` BETWEEN '2023-12-01 00:00:00' AND DATE_SUB('2024-01-01 23:59:59', INTERVAL 1 DAY), `Id_Booking`, NULL )) AS `Amount Diciembre`
            FROM (
                SELECT  `b`.`Id_Booking`,
                        `ps`.`Id_Passenger`,
                        `b`.`Booking_DateConfirm`,
                        `uc`.`Id_UserCountry`,
                        `uc`.`UserCountry_Name`,
                        YEAR(CURDATE())-YEAR(`ps`.`Passenger_DOB`) + IF(DATE_FORMAT(CURDATE(),'%m-%d') > DATE_FORMAT(`ps`.`Passenger_DOB`,'%m-%d'), 0 , -1 ) AS `Passenger_Age`
                FROM `t_booking` `b`
                INNER JOIN `t_passenger` `ps` ON `ps`.`Id_Booking` = `b`.`Id_Booking`
                INNER JOIN `t_user_country` `uc` ON `uc`.`Id_UserCountry` = `ps`.`Id_UserCountry`
                WHERE `b`.`Booking_DateConfirm` BETWEEN '2023-01-01 00:00:00' AND DATE_SUB('2024-01-01 23:59:59', INTERVAL 1 DAY)
                AND   `b`.`Booking_Status` IN (2, 3)
                AND   `ps`.`Passenger_Status` = 2
            ) `aux`
            GROUP BY `aux`.`Passenger_Age`
            ORDER BY `aux`.`Passenger_Age`",
            [$dateStart, $dateEnd, $limit]
        );
        // dd($data);
    }
}
