<?php

namespace App\Modules\Batch\Domain;

use App\Modules\Shared\Domain\ValueObject\StringValueObject;

final class BatchResource extends StringValueObject
{

    public static function generateResource(string $resourceText, $responses)
    {
        return new BatchResource(self::changeText($resourceText, $responses));
    }

    private static function changeText($value, $responses)
    {
        preg_match('/{.*}/', $value, $matches);
        array_map(
            function ($match) use (&$value, $responses) {
                $matchValue = substr($match, 1, strlen($match) - 2);
                $keys = explode('.', $matchValue);
                $data = $responses;
                foreach ($keys as $key) {
                    $data = self::getResponse($key, $data);
                    if ($data === null) {
                        break;
                    }
                }
                $value = str_replace($match, $data, $value);
            },
            $matches
        );
        return $value;
    }

    private static function getResponse($key, $data)
    {
        if (is_array($data)) {
            if (isset($data[$key])) {
                return $data[$key];
            }
        } else if (is_object($data)) {
            if (isset($data->{$key})) {
                return $data->{$key};
            }
        }
        return null;
    }
}
