<?php

namespace App\Modules\Batch\Domain;

class BatchRequest
{
    public function __construct(
        private BatchMethod $method,
        private BatchResource $resource,
        private BatchBody $body,
        private BatchToken $token,
        private BatchUrl $url,
        private BatchIp $ip,
    ) {
    }

    public function method(): BatchMethod
    {
        return $this->method;
    }

    public function resource(): BatchResource
    {
        return $this->resource;
    }

    public function body(): BatchBody
    {
        return $this->body;
    }

    public function token(): BatchToken
    {
        return $this->token;
    }

    public function url(): BatchUrl
    {
        return $this->url;
    }

    public function ip(): BatchIp
    {
        return $this->ip;
    }

    public function setResource(BatchResource $resource): void
    {
        $this->resource = $resource;
    }
}
