<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\TourHtlCamp\Application\TourHtlCampDeleter;
use App\Modules\TourHtlCamp\Application\TourHtlCampFinder;
use App\Modules\TourHtlCamp\Application\TourHtlCampIndexer;
use App\Modules\TourHtlCamp\Application\TourHtlCampInserter;
use App\Modules\TourHtlCamp\Application\TourHtlCampUpdater;
use App\Modules\TourHtlCamp\Domain\THCIdHtlCamp;
use App\Modules\TourHtlCamp\Domain\TourHtlCamp;
use App\Modules\TourHtlCamp\Domain\TourHtlCampDay;
use App\Modules\TourHtlCamp\Domain\TourHtlCampStatus;
use App\Modules\TourHtlCamp\Domain\IdTourHtlCamp;
use App\Modules\TourHtlCamp\Infraestructure\TourHtlCampValidators;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;
use App\Modules\Shared\Infraestructure\LaravelExceptionHandler;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\TourHtlCamp\Domain\THCIdTour;
use Throwable;

class c_Tour_Htl_Camp extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "TourHtlCamp";
        $this->history = new HistoryData(HistoryTables::TOUR_HTL_CAMP);
    }

    public function Insert(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, TourHtlCampValidators::insert);

        $oResponse = (new TourHtlCampInserter(new MysqlTourHtlCampRepository))->__invoke(
            new TourHtlCamp(
                new TourHtlCampDay($Request->input('TourHtlCamp_Day')),
                new TourHtlCampStatus($Request->input('TourHtlCamp_Status')),
                new THCIdTour($Request->input('Id_Tour')),
                new THCIdHtlCamp($Request->input('Id_HtlCamp'))
            )
        );
        $this->history->insert(
            (new TourHtlCampIndexer(new MysqlTourHtlCampRepository))->__invoke(new IdTourHtlCamp($oResponse['Response_Data']['Id'])),
            $Request,
            $oResponse['Response_Data']['Id']
        );

        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, TourHtlCampValidators::update);

        $this->history->obtainOld($Request->input('Id_TourHtlCamp'));

        $oResponse = (new TourHtlCampUpdater(new MysqlTourHtlCampRepository))->__invoke(
            new TourHtlCamp(
                new TourHtlCampDay($Request->input('TourHtlCamp_Day')),
                new TourHtlCampStatus($Request->input('TourHtlCamp_Status')),
                new THCIdTour(0),
                new THCIdHtlCamp(0),
                new IdTourHtlCamp($Request->input('Id_TourHtlCamp'))
            )
        );

        $this->history->update(
            $Request->input('Id_TourHtlCamp'),
            $this->history->oldValue,
            [],
            $Request
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function Index($Id)
    {
        $oResponse = (new TourHtlCampIndexer(new MysqlTourHtlCampRepository))->__invoke(new IdTourHtlCamp($Id));
        return ResponseBuilder::Response($oResponse);
    }

    public function List($Id_Tour, $Action)
    {
        $oResponse = (new TourHtlCampFinder(new MysqlTourHtlCampRepository))->__invoke(new THCIdTour($Id_Tour), $Action);
        return ResponseBuilder::Response($oResponse);
    }
}
