<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;

class c_Equipment extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Equipment";
		$this->history = new HistoryData (HistoryTables::equipment);
	}
	

	public function Insert(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Equipment_ShowOnBookingTour' => 'required|int',
								'Equipment_Status'    	=> 'required|int',
								'Id_Item'				=> 'required|int',
								'Id_TypeEquipment'		=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    $Request->input('Equipment_ShowOnBookingTour'),
								$Request->input("Equipment_Status"),
								$Request->input("Id_Item"),
								$Request->input("Id_TypeEquipment")
							);
			$oData = DB::select('call sp_equipment_insert(?,?,?,?)',$oParam);

			
			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->insertBasic ($Request);
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_Equipment'			=> 'required|int',
								'Equipment_ShowOnBookingTour' => 'required|int',
								'Equipment_Status'		=> 'required|int',
								'Id_Item'				=> 'required|int',
								'Id_TypeEquipment'		=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_Equipment'));
			//endregion
			$oParam = array(    $Request->input("Id_Equipment"),
								$Request->input('Equipment_ShowOnBookingTour'),
								$Request->input("Equipment_Status"),
								$Request->input("Id_Item"),
								$Request->input("Id_TypeEquipment")
							);
			$oData = DB::select('call sp_equipment_update(?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_Equipment"), $Request );
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY
			$this->history->obtainOld($Id);
			//endregion

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_equipment_delete(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_equipment_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {

			$oResponse = ParamsValidator::Validate_Request($Request, [ 'Id_TypeEquipment' => 'required|int' ], $this->oDomain);

			if ($oResponse['Response_Code'] == 200) {

				$oParam = [
					$Id,
					$Request->input ('Id_TypeEquipment')
				];

				$oData  = DB::select('call sp_equipment_list(?,?)', $oParam);

				$oResponse["Response_Status"]			= 200;
				$oResponse["Response_Code"]				= 200;
				$oResponse["Response_Domain"]			= $this->oDomain;
				$oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
				$oResponse["Response_Data"]				= $oData;
				$oResponse["Response_Error_Message"]	= "";
				$oResponse["Response_Error_Reason"]		= "";
			}
			
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function ListBookingTour(Request $Request, $Action){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Action($Action, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {

			$oResponse = ParamsValidator::Validate_Request($Request, [ 'Id_TypeEquipment' => 'required|int' ], $this->oDomain);

			if ($oResponse['Response_Code'] == 200) {

				$oParam = [
					$Action,
					$Request->input ('Id_TypeEquipment')
				];

				$oData  = DB::select('call sp_equipment_list_booking_tour(?,?)', $oParam);

				$oResponse["Response_Status"]			= 200;
				$oResponse["Response_Code"]				= 200;
				$oResponse["Response_Domain"]			= $this->oDomain;
				$oResponse["Response_Message"]			= $this->oDomain." list " . $Action;
				$oResponse["Response_Data"]				= $oData;
				$oResponse["Response_Error_Message"]	= "";
				$oResponse["Response_Error_Reason"]		= "";
			}
			
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	public function Selector(Request $Request,$Id){
		if( is_numeric($Id) ){
			return SELF::Index( $Request,$Id );
		}else{
			return SELF::List( $Request,$Id );
		}
	}
		
	
}