<?php

namespace App\Http\Controllers\Owner\WebContact;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\WebContact\Application\List\ListWebContactQuery;
use App\Modules\WebContact\Application\List\ListWebContactQueryResponse;

class WebContactListController extends Controller
{
    private $domain = 'WebContact';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action, Request $Request)
    {
        /** @var ListWebContactQueryResponse $response */
        $response = $this->queryBus->ask(new ListWebContactQuery($Action));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
