<?php

namespace App\Http\Controllers\Owner\WebContact;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\WebContact\Application\Index\IndexWebContactQuery;
use App\Modules\WebContact\Application\Index\IndexWebContactQueryResponse;

class WebContactIndexController extends Controller
{
    private $domain = 'WebContact';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var IndexWebContactQueryResponse $response */
        $response = $this->queryBus->ask(new IndexWebContactQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
