<?php

namespace App\Http\Controllers\Owner\WebContact;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\WebContact\Application\Delete\DeleteWebContactQuery;
use App\Modules\WebContact\Application\Delete\DeleteWebContactQueryResponse;

class WebContactDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::WEB_CONTACT);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        /** @var DeleteWebContactQueryResponse $response */
        $response = $this->queryBus->ask(new DeleteWebContactQuery($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response->response());
    }
}
